function [m se] = plotAverageResponse(total, numFrames, frameRate, labels, tit, raw, stimOn, stimOff)

%I am going to try to edit Nikhil's plotAverageResponse script (from which
%this is derived) to instead of plotting averages plot individual traces as
%lines. So, you'd input one calcium imaging file and it would plot all the
%individual worms on one axis to let you see the individual behaviors.
%-ss

yBar = 140; %175 for typical M1 totalRel experiments, ~140 for pm tip and ~70 for pm bulb
color = [0 0 0] ./ 255; 
%color = [98 0 255] ./ 255;

colors = [ 0    0    0;
           1.0  0    0;
           %0    0    1.0;
           0    0.69 0.31; 
           1.0  0.35 0;
           0.73 0.20 1.0;];
            
            
shading = [ .8  .8  .8;
           1.0  .8  .8; 
            %.8  .8 1.0;
            .8 1.0  .9;
           1.0  .9  .8;
            .9  .8 1.0;];

% Each cell in total contains a 2-D array of time vs. cell
for i = 1:length(total)
    m(:,i) = mean(total{i}, 2);
    se(:,i) = std(total{i}, 0, 2) / sqrt(size(total{i}, 2));
end

if (~strcmp(raw, 'raw'))
    m = m .* 100;
    se = se .* 100;
end

figure;
hold on;

x = (0:(numFrames-1)) / frameRate;

h = [];
for i=1:length(labels)
    p = patch([x x(end:-1:1)], cat(1, m(:,i)+se(:,i), m(end:-1:1,i)-se(end:-1:1,i)), ...
        shading(i,:), 'LineStyle', 'none');
end
for i=1:length(labels)
    h(i) = plot(x, m(:,i), 'LineWidth', 2, 'Color', colors(i,:));
end

if (stimOn >= 0)
    plot([stimOn stimOff], [yBar yBar], 'LineWidth', 30, 'Color', color);
    text((stimOn+stimOff)/2, yBar, ...
        ['Light'],...
        'FontWeight', 'bold', 'FontSize', 20, 'Color', [1 1 1], ...
        'HorizontalAlignment', 'center');
end

if (strcmp(raw, 'raw'))
    ylabel('fluorescence (au)', 'FontWeight', 'bold', 'FontSize', 20);
else
    ylabel('F/F_0 (%)', 'FontWeight', 'bold', 'FontSize', 20);
end
xlabel('time (s)', 'FontWeight', 'bold', 'FontSize', 20);
title(tit, 'FontWeight', 'bold', 'FontSize', 20);
prettify;
legend(h, labels);
ylim([0 200]);

end